/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.listener.utils;

import filenet.vw.api.VWSession;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.base.logging.Logger;
import filenet.ws.api.WSDefinition;
import filenet.ws.api.WSPort;
import filenet.ws.api.WSService;
import filenet.ws.listener.utils.WSListenerProperties;
import filenet.ws.utils.WSConstants;
import filenet.ws.utils.WSWorkflowWSDLGenerator;
import java.io.InputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.wsdl.extensions.soap.SOAPAddress;
import org.apache.axis.utils.XMLUtils;
import org.w3c.dom.Document;

public class WSDLManager {
    protected static final Logger logger = Logger.getLogger("filenet.ws.listener.wsdl");
    protected static final String m_className = "WSDLManager";
    private static Hashtable gWSDLCache = new Hashtable();
    private static Hashtable gWFCache = new Hashtable();
    private static Hashtable gWSDLStringCache = new Hashtable();
    private static Hashtable gWFStringCache = new Hashtable();
    private static long gCaches_TimeStamp = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object internalGetWorkClassWSDLorWF(String workClassName, int workSpaceId, WSListenerProperties wsListenerProperties, boolean wantWF, VWSession vwSession, VWWorkflowDefinition def, String cpName, String key) throws Throwable {
        String m_method = null;
        m_method = wantWF ? "internalGetWorkClassWSDLor(WF):" + key : "internalGetWorkClass(WSDL)orWF:" + key;
        try {
            Hashtable hashtable;
            long curTime;
            logger.entering(m_className, m_method);
            long m_cacheTimeout = 4L;
            try {
                m_cacheTimeout = Long.parseLong(wsListenerProperties.getProperty("filenet.ws.listener.cache.timeout"));
            }
            catch (Exception e) {
                // empty catch block
            }
            m_cacheTimeout = m_cacheTimeout * 60L * 60L * 1000L;
            if (gWFCache.size() != 0 && m_cacheTimeout > 0L && m_cacheTimeout <= (curTime = new Date().getTime()) - gCaches_TimeStamp) {
                WSDLManager.ClearCaches();
            }
            gCaches_TimeStamp = new Date().getTime();
            Object wsdlInfo = null;
            if (wantWF) {
                hashtable = gWFCache;
                synchronized (hashtable) {
                    wsdlInfo = gWFCache.get(key);
                }
            }
            hashtable = gWSDLCache;
            synchronized (hashtable) {
                wsdlInfo = gWSDLCache.get(key);
            }
            if (wsdlInfo == null) {
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "get Workflow Definition");
                }
                if (vwSession == null) {
                    vwSession = wsListenerProperties.getVWSession(cpName);
                }
                if (def == null) {
                    def = vwSession.fetchWorkflowDefinition(workSpaceId, workClassName, false);
                }
                hashtable = gWFCache;
                synchronized (hashtable) {
                    gWFCache.put(key, def);
                }
                if (wantWF) {
                    wsdlInfo = def;
                } else {
                    String soapAddress = wsListenerProperties.getProperty("listener.base.url") + (cpName == null || cpName.length() == 0 ? "" : "/wscp" + WSConstants.UTF8Encode(cpName)) + "/wc/" + WSConstants.UTF8Encode(workClassName);
                    if (!def.getVersionAgnostic()) {
                        soapAddress = soapAddress + "/" + Integer.toString(workSpaceId);
                    }
                    if (logger.isFinest()) {
                        logger.finest(m_className, m_method, "soapAddress=" + soapAddress);
                    }
                    WSWorkflowWSDLGenerator wsdlGen = null;
                    try {
                        wsdlGen = new WSWorkflowWSDLGenerator(vwSession, def, soapAddress);
                        wsdlInfo = wsdlGen.getWSDefinition();
                        Hashtable hashtable2 = gWSDLCache;
                        synchronized (hashtable2) {
                            gWSDLCache.put(key, wsdlInfo);
                        }
                        Object var18_21 = null;
                        if (wsdlGen != null) {
                            wsdlGen.releaseReferences();
                            wsdlGen = null;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var18_22 = null;
                        if (wsdlGen != null) {
                            wsdlGen.releaseReferences();
                            wsdlGen = null;
                        }
                        throw throwable;
                    }
                }
            }
            hashtable = wsdlInfo;
            Object var20_24 = null;
            logger.exiting(m_className, m_method);
            return hashtable;
        }
        catch (Throwable e) {
            try {
                logger.throwing(m_className, m_method, e);
                throw e;
            }
            catch (Throwable throwable) {
                Object var20_25 = null;
                logger.exiting(m_className, m_method);
                throw throwable;
            }
        }
    }

    public static Object getWorkClassWSDLorWF(String workClassName, int workSpaceId, WSListenerProperties wsListenerProperties, boolean wantWF, String cpName) throws Throwable {
        return WSDLManager.internalGetWorkClassWSDLorWF(workClassName, workSpaceId, wsListenerProperties, wantWF, null, null, cpName, WSDLManager.constructKey(cpName, workClassName, workSpaceId));
    }

    private static String constructKey(String cpName, String workClassName, int workSpaceId) {
        return cpName + "***" + workClassName + "/" + workSpaceId + "___";
    }

    public static String genWorkClassWSDLorWF(String workClassName, int workSpaceId, WSListenerProperties wsListenerProperties, boolean wantWF, String cpName, VWSession vwSession) throws Throwable {
        String key = WSDLManager.constructKey(cpName, workClassName, workSpaceId);
        String m_method = null;
        m_method = wantWF ? "genWorkClassWSDLor(WF):" + key : "genWorkClass(WSDL)orWF:" + key;
        try {
            logger.entering(m_className, m_method);
            Object obj = null;
            VWWorkflowDefinition def = null;
            if (workSpaceId == -1) {
                if (vwSession == null) {
                    vwSession = wsListenerProperties.getVWSession(cpName);
                }
                def = vwSession.fetchWorkflowDefinition(workSpaceId, workClassName, false);
                workSpaceId = def.getRuntimeId().getWorkSpaceId();
            }
            if ((obj = WSDLManager.internalGetWorkClassWSDLorWF(workClassName, workSpaceId, wsListenerProperties, wantWF, vwSession, def, cpName, key)) == null) {
                throw new Exception("Unavailable information.");
            }
            String res = null;
            if (wantWF) {
                res = (String)gWFStringCache.get(obj);
                if (res == null) {
                    VWWorkflowDefinition wfObj = (VWWorkflowDefinition)obj;
                    StringBuffer buf = new StringBuffer();
                    wfObj.toXML(buf);
                    res = buf.toString();
                    gWFStringCache.put(obj, res);
                }
            } else {
                res = (String)gWSDLStringCache.get(obj);
                if (res == null) {
                    WSDefinition wsdlObj = (WSDefinition)obj;
                    res = wsdlObj.writeToString();
                    gWSDLStringCache.put(obj, res);
                }
            }
            String string = res;
            Object var14_14 = null;
            logger.exiting(m_className, m_method);
            return string;
        }
        catch (Throwable e) {
            try {
                logger.throwing(m_className, m_method, e);
                throw e;
            }
            catch (Throwable throwable) {
                Object var14_15 = null;
                logger.exiting(m_className, m_method);
                throw throwable;
            }
        }
    }

    public static String genUddiV2WSDL(String soapAddressURL) throws Throwable {
        String m_method = "genUddiV2WSDL:" + soapAddressURL;
        try {
            logger.entering(m_className, m_method);
            WSDefinition def = null;
            String res = null;
            String key = "filenet/ws/listener/utils/inquire_v2.wsdl";
            WSDefinition wsdlInfo = (WSDefinition)gWSDLCache.get(key);
            if (wsdlInfo != null && wsdlInfo instanceof WSDefinition) {
                def = wsdlInfo;
            } else {
                def = WSDLManager.getWSDL("filenet/ws/listener/utils/inquire_v2.wsdl");
                if (def != null) {
                    WSService service = def.getService("InquireService");
                    WSPort port = null;
                    if (service != null && (port = service.getPort("Inquire")) != null) {
                        SOAPAddress soapAddress = port.getSoapAddress();
                        soapAddress.setLocationURI(soapAddressURL);
                    }
                    gWSDLCache.put(key, def);
                } else if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "Failed to load uddi wsdl - filenet/ws/listener/utils/inquire_v2.wsdl");
                }
            }
            if (def != null) {
                res = def.writeToString();
            }
            String string = res;
            Object var10_10 = null;
            logger.exiting(m_className, m_method);
            return string;
        }
        catch (Throwable e) {
            try {
                logger.throwing(m_className, m_method, e);
                throw e;
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                logger.exiting(m_className, m_method);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static WSDefinition getWSDL(String wsdlString) throws Throwable {
        WSDefinition wsdlDef;
        String m_method;
        block7: {
            m_method = "getWSDL:" + wsdlString;
            logger.entering(m_className, m_method);
            InputStream inStream = null;
            wsdlDef = null;
            try {
                inStream = new WSDLManager().getClass().getClassLoader().getResourceAsStream(wsdlString);
                int size = inStream.available();
                if (size > 0) {
                    Document wsdlDoc = XMLUtils.newDocument((InputStream)inStream);
                    wsdlDef = new WSDefinition(wsdlDoc);
                }
                Object var7_6 = null;
                if (inStream == null) break block7;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (inStream != null) {
                    try {
                        inStream.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                logger.exiting(m_className, m_method);
                throw throwable;
            }
            try {
                inStream.close();
                break block7;
            }
            catch (Exception e) {
                // empty catch block
            }
            {
            }
        }
        logger.exiting(m_className, m_method);
        return wsdlDef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ClearCaches() {
        Enumeration e;
        String m_method = "ClearCaches";
        Hashtable hashtable = gWSDLCache;
        synchronized (hashtable) {
            e = gWSDLCache.keys();
            Object obj = null;
            while (e.hasMoreElements()) {
                obj = gWSDLCache.remove(e.nextElement());
                if (obj == null || !(obj instanceof WSDefinition)) continue;
                ((WSDefinition)obj).releaseReferences();
                obj = null;
            }
            gWSDLCache.clear();
            if (logger.isFinest()) {
                logger.finest(m_className, "ClearCaches", "cleared WSDL Cache.");
            }
        }
        hashtable = gWSDLStringCache;
        synchronized (hashtable) {
            e = gWSDLStringCache.keys();
            while (e.hasMoreElements()) {
                gWSDLStringCache.remove(e.nextElement());
            }
            gWSDLStringCache.clear();
            if (logger.isFinest()) {
                logger.finest(m_className, "ClearCaches", "cleared WSDL String Cache.");
            }
        }
        hashtable = gWFCache;
        synchronized (hashtable) {
            e = gWFCache.keys();
            while (e.hasMoreElements()) {
                gWFCache.remove(e.nextElement());
            }
            gWFCache.clear();
            if (logger.isFinest()) {
                logger.finest(m_className, "ClearCaches", "clear WF Cache.");
            }
        }
        hashtable = gWFStringCache;
        synchronized (hashtable) {
            e = gWFStringCache.keys();
            while (e.hasMoreElements()) {
                gWFStringCache.remove(e.nextElement());
            }
            gWFStringCache.clear();
            if (logger.isFinest()) {
                logger.finest(m_className, "ClearCaches", "cleared WF String Cache.");
            }
        }
    }
}

